
import gurobi as gp

# Define variables
x0 = gp.Var(name="bowls of pasta", lb=0, ub=None, vtype=gp.GRB.INTEGER)
x1 = gp.Var(name="bowls of cereal", lb=0, ub=None)
x2 = gp.Var(name="rotisserie chickens", lb=0, ub=None, vtype=gp.GRB.INTEGER)
x3 = gp.Var(name="apples", lb=0, ub=None, vtype=gp.GRB.INTEGER)
x4 = gp.Var(name="corn cobs", lb=0, ub=None, vtype=gp.GRB.INTEGER)
x5 = gp.Var(name="blueberry pies", lb=0, ub=None, vtype=gp.GRB.INTEGER)

# Create model
m = gp.Model()

# Objective function
obj = 1.46*x0**2 + 4.92*x0*x1 + 1.71*x0*x2 + 3.74*x1*x2 + 2.27*x1*x3 + 3.68*x1*x4 + 9.9*x1*x5 + 4.54*x2**2 + 5.5*x2*x3 + 5.58*x2*x4 + 9.16*x3**2 + 2.59*x3*x4 + 9.65*x3*x5 + 7.66*x4**2 + 9.4*x5**2 + 2.37*x0 + 4.73*x1 + 5.74*x2 + 7.68*x3 + 4.96*x5

# Set objective
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x0 + 3*x1 + 5*x2 + 5*x3 + 7*x4 + 6*x5 <= 90)
m.addConstr(5*x0 + x1 + 7*x2 + 7*x3 + 5*x4 + 8*x5 <= 63)
m.addConstr(5*x0 + 4*x1 + 4*x2 + x3 + 4*x4 + 3*x5 <= 85)
m.addConstr(4*x0 + 6*x1 + 7*x2 + 7*x3 + 6*x4 + 2*x5 <= 73)
m.addConstr(8*x1 + 3*x5 >= 5)
m.addConstr(8*x0 + 3*x1 >= 5)
m.addConstr(8*x0 + 7*x4 >= 8)
m.addConstr(3*x1 + 5*x3 + 6*x5 >= 10)
m.addConstr(x1**2 + x4**2 + x5**2 >= 10)
m.addConstr(10*x0**2 + x1**2 + x3**2 >= 10)
m.addConstr(5*x2 + 7*x4 + 6*x5 >= 10)

# ... add many more constraints

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("bowls of pasta: ", x0.varValue)
    print("bowls of cereal: ", x1.varValue)
    print("rotisserie chickens: ", x2.varValue)
    print("apples: ", x3.varValue)
    print("corn cobs: ", x4.varValue)
    print("blueberry pies: ", x5.varValue)
else:
    print("No optimal solution found")
