
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")


# Set objective function
m.setObjective(7.9*george**2 + 5.04*george*laura + 2.32*george*ringo + 9.75*george*peggy + 5.15*laura*ringo + 7.88*laura*peggy + 8.43*john**2 + 8.85*john*peggy + 3.52*ringo**2 + 9.29*ringo*peggy + 5.95*peggy**2 + 2.83*george + 3.33*john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.15*laura + 3.94*john >= 40)
m.addConstr(2.67*george**2 + 2.15*laura**2 >= 29)
m.addConstr(2.15*laura + 3.94*john + 5.65*ringo >= 33)
m.addConstr(2.67*george + 2.15*laura + 3.94*john + 5.65*ringo + 2.63*peggy >= 33)
m.addConstr(1.87*ringo + 2.6*peggy >= 7)
m.addConstr(1.92*laura + 1.87*ringo >= 4)
m.addConstr(1.38*john + 1.87*ringo >= 5)
m.addConstr(1.45*george + 1.87*ringo >= 6)
m.addConstr(1.45*george + 2.6*peggy >= 5)
m.addConstr(1.92*laura + 1.38*john >= 2)
m.addConstr(1.45*george + 1.38*john >= 2)
m.addConstr(1.45*george**2 + 1.92*laura**2 + 1.87*ringo**2 >= 4)
m.addConstr(1.45*george + 1.38*john + 1.87*ringo >= 4)
m.addConstr(1.38*john**2 + 1.87*ringo**2 + 2.6*peggy**2 >= 4)
m.addConstr(1.92*laura**2 + 1.87*ringo**2 + 2.6*peggy**2 >= 4)
m.addConstr(1.45*george + 1.38*john + 2.6*peggy >= 4)
m.addConstr(1.92*laura + 1.38*john + 1.87*ringo >= 4)
m.addConstr(1.45*george + 1.92*laura + 1.38*john >= 4)
m.addConstr(1.92*laura + 1.38*john + 2.6*peggy >= 4)
m.addConstr(1.45*george**2 + 1.92*laura**2 + 2.6*peggy**2 >= 4)
m.addConstr(1.45*george + 1.92*laura + 1.87*ringo >= 3)

# ... (The rest of the 3-dollar and 6-dollar cost constraints are added similarly)

m.addConstr(8*ringo**2 - 3*peggy**2 >= 0)
m.addConstr(2.67*george + 2.63*peggy <= 105)
m.addConstr(5.65*ringo + 2.63*peggy <= 74)
m.addConstr(3.94*john**2 + 5.65*ringo**2 + 2.63*peggy**2 <= 87)
m.addConstr(1.45*george + 1.92*laura <= 27)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
