
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by George
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Laura
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Ringo
    x4 = model.addVar(name="x4", lb=0)  # hours worked by Peggy

    # Objective function
    model.setObjective(7.9 * x0**2 + 5.04 * x0 * x1 + 2.32 * x0 * x3 + 9.75 * x0 * x4 +
                       5.15 * x1 * x3 + 7.88 * x1 * x4 + 8.43 * x2**2 + 8.85 * x2 * x4 +
                       3.52 * x3**2 + 9.29 * x3 * x4 + 5.95 * x4**2 + 2.83 * x0 + 3.33 * x2,
                       gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2.67 * x0 <= 212)
    model.addConstr(1.45 * x0 <= 39)
    model.addConstr(2.15 * x1 <= 212)
    model.addConstr(1.92 * x1 <= 39)
    model.addConstr(3.94 * x2 <= 212)
    model.addConstr(1.38 * x2 <= 39)
    model.addConstr(5.65 * x3 <= 212)
    model.addConstr(1.87 * x3 <= 39)
    model.addConstr(2.63 * x4 <= 212)
    model.addConstr(2.6 * x4 <= 39)
    model.addConstr(2.15 * x1 + 3.94 * x2 >= 40)
    model.addConstr(2.67**2 * x0**2 + 2.15**2 * x1**2 >= 29)
    model.addConstr(5.65 * x3 + 3.94 * x2 + 2.15 * x1 >= 33)
    model.addConstr(2.67 * x0 + 2.15 * x1 + 3.94 * x2 + 5.65 * x3 + 2.63 * x4 >= 33)
    model.addConstr(1.87 * x3 + 2.6 * x4 >= 7)
    model.addConstr(1.92 * x1 + 1.87 * x3 >= 4)
    model.addConstr(1.38 * x2 + 1.87 * x3 >= 5)
    model.addConstr(1.45 * x0 + 1.87 * x3 >= 6)
    model.addConstr(2.6 * x4 + 1.45 * x0 >= 5)
    model.addConstr(1.92 * x1 + 1.38 * x2 >= 2)
    model.addConstr(1.45 * x0 + 1.38 * x2 >= 2)
    model.addConstr(1.45**2 * x0**2 + 1.92**2 * x1**2 + 1.87**2 * x3**2 >= 4)
    model.addConstr(1.45 * x0 + 1.38 * x2 + 1.87 * x3 >= 4)
    model.addConstr(1.38**2 * x2**2 + 1.87**2 * x3**2 + 2.6**2 * x4**2 >= 4)
    model.addConstr(1.92**2 * x1**2 + 1.87**2 * x3**2 + 2.6**2 * x4**2 >= 4)
    model.addConstr(1.45 * x0 + 1.38 * x2 + 2.6 * x4 >= 4)
    model.addConstr(1.92 * x1 + 1.38 * x2 + 2.6 * x4 >= 4)
    model.addConstr(1.45**2 * x0**2 + 1.92**2 * x1**2 + 2.6**2 * x4**2 >= 4)
    model.addConstr(1.45 * x0 + 1.92 * x1 + 1.87 * x3 >= 3)
    model.addConstr(1.45 * x0 + 1.38 * x2 + 1.87 * x3 >= 3)
    model.addConstr(1.87 * x3 + 2.6 * x4 + 1.38 * x2 >= 3)
    model.addConstr(1.92**2 * x1**2 + 1.87**2 * x3**2 + 2.6**2 * x4**2 >= 3)
    model.addConstr(1.45**2 * x0**2 + 1.38**2 * x2**2 + 2.6**2 * x4**2 >= 3)
    model.addConstr(1.92**2 * x1**2 + 1.38**2 * x2**2 + 1.87**2 * x3**2 >= 3)
    model.addConstr(1.45**2 * x0**2 + 1.92**2 * x1**2 + 1.38**2 * x2**2 >= 3)
    model.addConstr(1.92**2 * x1**2 + 1.38**2 * x2**2 + 2.6**2 * x4**2 >= 3)
    model.addConstr(1.45 * x0 + 1.92 * x1 + 1.87 * x3 >= 6)
    model.addConstr(1.45 * x0 + 1.38 * x2 + 1.87 * x3 >= 6)
    model.addConstr(1.87 * x3 + 2.6 * x4 + 1.38 * x2 >= 6)
    model.addConstr(1.45 * x0 + 1.92 * x1 + 1.38 * x2 >= 6)
    model.addConstr(8 * x3**2 - 3 * x4**2 >= 0)
    model.addConstr(2.67 * x0 + 2.63 * x4 <= 105)
    model.addConstr(5.65 * x3 + 2.63 * x4 <= 74)
    model.addConstr(5.65**2 * x3**2 + 3.94**2 * x2**2 + 2.63**2 * x4**2 <= 87)
    model.addConstr(1.45 * x0 + 1.92 * x1 <= 27)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
