
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Computer_Competence_Optimization")

# Create variables
ringo_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")
hank_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
laura_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="laura_hours")


# Set objective function
m.setObjective(4.1 * ringo_hours + 6.3 * hank_hours + 7.72 * laura_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * ringo_hours + 10 * laura_hours >= 19, "c1")
m.addConstr(7 * ringo_hours + 14 * hank_hours >= 20, "c2")
m.addConstr(7 * ringo_hours + 14 * hank_hours + 10 * laura_hours >= 20, "c3")
m.addConstr(6 * hank_hours - 4 * laura_hours >= 0, "c4")
m.addConstr(7 * ringo_hours + 14 * hank_hours <= 52, "c5")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Ringo's hours: {ringo_hours.x}")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Laura's hours: {laura_hours.x}")
    print(f"Objective Value: {m.objVal}")

