
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)  # Ringo
    x2 = model.addVar(name="hours_worked_by_Hank", lb=0)  # Hank
    x3 = model.addVar(name="hours_worked_by_Laura", lb=0, vtype=gurobi.GRB.INTEGER)  # Laura

    # Objective function
    model.setObjective(4.1 * x1 + 6.3 * x2 + 7.72 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 10 * x3 >= 19)
    model.addConstr(7 * x1 + 14 * x2 >= 20)
    model.addConstr(7 * x1 + 14 * x2 + 10 * x3 >= 20)
    model.addConstr(6 * x2 - 4 * x3 >= 0)
    model.addConstr(7 * x1 + 14 * x2 <= 52)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Hours worked by Hank: {x2.varValue}")
        print(f"Hours worked by Laura: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
