
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=0, type=gurobi.GRB.INTEGER)  # milligrams of vitamin A
    x2 = model.addVar(name="x2", lb=0, type=gurobi.GRB.INTEGER)  # milligrams of vitamin B5
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B3
    x4 = model.addVar(name="x4", lb=0)  # milligrams of iron

    # Objective function
    model.setObjective(9.87 * x1 + 2.03 * x2 + 7.26 * x3 + 4.87 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(29 * x1 <= 303)
    model.addConstr(21 * x2 <= 303)
    model.addConstr(31 * x3 <= 303)
    model.addConstr(29 * x4 <= 303)

    model.addConstr(x2 + x4 >= 26)
    model.addConstr(29 * x1 + 29 * x4 >= 41)
    model.addConstr(29 * x1 + 21 * x2 >= 27)
    model.addConstr(21 * x2 + 31 * x3 >= 71)
    model.addConstr(31 * x3 + 29 * x4 >= 31)
    model.addConstr(29 * x1 + 31 * x3 >= 39)
    model.addConstr(21 * x2 + 31 * x3 + 29 * x4 >= 56)
    model.addConstr(29 * x1 + 21 * x2 + 31 * x3 + 29 * x4 >= 56)
    model.addConstr(7 * x2 - 4 * x4 >= 0)
    model.addConstr(21 * x2 + 31 * x3 <= 293)
    model.addConstr(29 * x1 + 31 * x3 <= 184)

    # Solve the problem
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
