
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Iron Intake")

# Create variables
fruit_salads = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
pickles = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")

# Set objective function
model.setObjective(1.26 * fruit_salads + 7.37 * pickles, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * fruit_salads + 19 * pickles >= 69, "min_iron")
model.addConstr(2 * fruit_salads - 5 * pickles >= 0, "fruit_salad_pickles_ratio")
model.addConstr(4 * fruit_salads + 19 * pickles <= 186, "max_iron1")
model.addConstr(4 * fruit_salads + 19 * pickles <= 186, "max_iron2")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Fruit Salads: {fruit_salads.x}")
    print(f"Pickles: {pickles.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

