
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")

# Set the objective function
m.setObjective(1.26*x1 + 7.37*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 19*x2 >= 69, "iron_minimum")
m.addConstr(4*x1 + 19*x2 <= 186, "iron_maximum")
m.addConstr(2*x1 - 5*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
