
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="fruit_salads", lb=0, ub=None)  # Assuming non-negative
    x2 = model.addVar(name="pickles", lb=0, ub=None)     # Assuming non-negative

    # Objective function
    model.setObjective(1.26 * x1 + 7.37 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 19 * x2 >= 69, name="iron_min")
    model.addConstr(2 * x1 - 5 * x2 >= 0, name="combination_constraint")
    model.addConstr(4 * x1 + 19 * x2 <= 186, name="iron_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Fruit Salads: ", x1.varValue)
        print("Pickles: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
