
import gurobi as gp

# Define variables
x = gp.mvar(6, name="x", lb=0)

# Define model
model = gp.Model()

# Objective function
model.setObjective(1.36*x[0]**2 + 4.33*x[0]*x[1] + 9.9*x[1]*x[2] + 9.03*x[2]*x[4] + 8.22*x[2]*x[5] + 
                   7.37*x[3]*x[5] + 6.95*x[4]*x[5] + 1.11*x[0] + 6.63*x[1] + 2.13*x[2] + 2.25*x[3], 
                   sense=gp.GRB.MAXIMIZE)

# Constraints
# Resource constraints
model.addConstr(8.49*x[0] + 6.78*x[1] + 13.22*x[2] + 1.16*x[3] + 9.54*x[4] + 14.58*x[5] <= 343)
model.addConstr(12.04*x[0] + 8.45*x[1] + 13.92*x[2] + 11.57*x[3] + 0.58*x[4] + 6.75*x[5] <= 420)
model.addConstr(11.84*x[0] + 1.74*x[1] + 8.63*x[2] + 0.85*x[3] + 3.88*x[4] + 12.18*x[5] <= 270)

# Iron constraints
model.addConstr(8.49*x[0]**2 + 13.22*x[2]**2 >= 54)

# Calcium constraints
model.addConstr(13.92*x[2] + 11.57*x[3] + 0.58*x[4] >= 52)

# Cost constraints
model.addConstr(8.63*x[2] + 0.85*x[3] + 3.88*x[4] >= 26)

# Solve model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    for i in range(6):
        print(f"x[{i}] = {x[i].varValue}")
else:
    print("No optimal solution found")
