
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x5")


# Set objective function
m.setObjective(x0**2 + 6*x0*x1 + x0*x2 + x0*x3 + x0*x4 + 6*x0*x5 + 4*x1**2 + 3*x1*x3 + 2*x2**2 + 4*x2*x3 + 7*x2*x4 + 8*x2*x5 + 6*x3*x4 + 7*x5**2 + 4*x1 + 2*x3 + 5*x4 + 9*x5, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1**2 + 8*x5**2 >= 99)
m.addConstr(26*x4**2 + 8*x5**2 >= 124)
m.addConstr(15*x2 + 24*x3 + 8*x5 >= 140)
m.addConstr(15*x2 + 26*x4 + 8*x5 >= 140)
m.addConstr(15*x2 + 24*x3 + 26*x4 >= 140)
m.addConstr(23*x0**2 + 8*x1**2 + 15*x2**2 >= 140)
m.addConstr(15*x2 + 24*x3 + 8*x5 >= 104)
m.addConstr(15*x2 + 26*x4 + 8*x5 >= 104)
m.addConstr(15*x2**2 + 24*x3**2 + 26*x4**2 >= 104)
m.addConstr(23*x0 + 8*x1 + 15*x2 >= 104)
m.addConstr(15*x2**2 + 24*x3**2 + 8*x5**2 >= 127)
m.addConstr(15*x2 + 26*x4 + 8*x5 >= 127)
m.addConstr(15*x2 + 24*x3 + 26*x4 >= 127)
m.addConstr(23*x0 + 8*x1 + 15*x2 >= 127)
m.addConstr(15*x2 + 24*x3 + 8*x5 >= 81)
m.addConstr(15*x2**2 + 26*x4**2 + 8*x5**2 >= 81)
m.addConstr(15*x2 + 24*x3 + 26*x4 >= 81)
m.addConstr(23*x0**2 + 8*x1**2 + 15*x2**2 >= 81)
m.addConstr(23*x0 + 8*x1 + 15*x2 + 24*x3 + 26*x4 + 8*x5 >= 81)
m.addConstr(-2*x4 + 9*x5 >= 0)
m.addConstr(-2*x0 - x3 + 2*x4 >= 0)
m.addConstr(8*x1 + 24*x3 <= 305)
m.addConstr(8*x1 + 8*x5 <= 335)
m.addConstr(23*x0 + 15*x2 <= 531)
m.addConstr(15*x2 + 24*x3 <= 208)
m.addConstr(23*x0 + 8*x5 <= 601)
m.addConstr(15*x2 + 24*x3 + 26*x4 <= 611)
m.addConstr(23*x0 + 26*x4 + 8*x5 <= 595)
m.addConstr(8*x1 + 15*x2 + 24*x3 <= 292)
m.addConstr(15*x2 + 26*x4 + 8*x5 <= 681)
m.addConstr(23*x0 + 8*x1 + 15*x2 + 24*x3 + 26*x4 + 8*x5 <= 945)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

