
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin K")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin E")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin A")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin B3")
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin B9")
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, name="grams of carbohydrates")

    # Objective function
    model.setObjective(x1**2 + 6*x1*x2 + x1*x3 + x1*x4 + x1*x5 + 6*x1*x6 + 
                      4*x2**2 + 3*x2*x4 + 2*x3**2 + 4*x3*x4 + 7*x3*x5 + 8*x3*x6 + 
                      6*x4*x5 + 7*x6**2 + 4*x2 + 2*x4 + 5*x5 + 9*x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23*x1 <= 945)
    model.addConstr(8*x2 <= 945)
    model.addConstr(15*x3 <= 945)
    model.addConstr(24*x4 <= 945)
    model.addConstr(26*x5 <= 945)
    model.addConstr(8*x6 <= 945)
    model.addConstr(8*x2**2 + 8*x6**2 >= 99)
    model.addConstr(26*x5**2 + 8*x6**2 >= 124)
    model.addConstr(15*x3 + 24*x4 + 8*x6 >= 140)
    model.addConstr(15*x3 + 26*x5 + 8*x6 >= 140)
    model.addConstr(15*x3 + 24*x4 + 26*x5 >= 140)
    model.addConstr(23*x1**2 + 8*x2**2 + 15*x3**2 >= 140)
    model.addConstr(15*x3 + 24*x4 + 8*x6 >= 104)
    model.addConstr(15*x3 + 26*x5 + 8*x6 >= 104)
    model.addConstr(15*x3**2 + 24*x4**2 + 26*x5**2 >= 104)
    model.addConstr(23*x1 + 8*x2 + 15*x3 >= 104)
    model.addConstr(15*x3**2 + 24*x4**2 + 8*x6**2 >= 127)
    model.addConstr(15*x3 + 26*x5 + 8*x6 >= 127)
    model.addConstr(15*x3 + 24*x4 + 26*x5 >= 127)
    model.addConstr(23*x1 + 8*x2 + 15*x3 >= 127)
    model.addConstr(15*x3 + 24*x4 + 8*x6 >= 81)
    model.addConstr(15*x3**2 + 26*x5**2 + 8*x6**2 >= 81)
    model.addConstr(15*x3 + 24*x4 + 26*x5 >= 81)
    model.addConstr(23*x1**2 + 8*x2**2 + 15*x3**2 >= 81)
    model.addConstr(23*x1 + 8*x2 + 15*x3 + 24*x4 + 26*x5 + 8*x6 >= 81)
    model.addConstr(-2*x5 + 9*x6 >= 0)
    model.addConstr(-2*x1 - x4 + 2*x5 >= 0)
    model.addConstr(8*x2 + 24*x4 <= 305)
    model.addConstr(8*x2 + 8*x6 <= 335)
    model.addConstr(23*x1 + 15*x3 <= 531)
    model.addConstr(15*x3 + 24*x4 <= 208)
    model.addConstr(23*x1 + 8*x6 <= 601)
    model.addConstr(15*x3 + 24*x4 + 26*x5 <= 611)
    model.addConstr(23*x1 + 26*x5 + 8*x6 <= 595)
    model.addConstr(8*x2 + 15*x3 + 24*x4 <= 292)
    model.addConstr(15*x3 + 26*x5 + 8*x6 <= 681)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
