
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
network_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")


# Set objective function
m.setObjective(2*security_engineers + 1*system_administrators + 7*network_administrators + 6*pen_testers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1*security_engineers + 11*system_administrators >= 13)
m.addConstr(1*security_engineers + 7*pen_testers >= 15)
m.addConstr(5*network_administrators + 7*pen_testers >= 15)
m.addConstr(1*security_engineers + 11*system_administrators + 5*network_administrators + 7*pen_testers >= 15)
m.addConstr(1*network_administrators + 7*pen_testers >= 15)
m.addConstr(4*system_administrators + 1*network_administrators >= 20)
m.addConstr(9*security_engineers + 1*network_administrators >= 16)
m.addConstr(9*security_engineers + 1*network_administrators + 7*pen_testers >= 22)
m.addConstr(9*security_engineers + 4*system_administrators + 1*network_administrators + 7*pen_testers >= 22)
m.addConstr(14*security_engineers + 12*system_administrators >= 13)
m.addConstr(14*security_engineers + 4*network_administrators >= 11)
m.addConstr(12*system_administrators + 4*pen_testers >= 11)
m.addConstr(14*security_engineers + 4*pen_testers >= 21)
m.addConstr(14*security_engineers + 12*system_administrators + 4*pen_testers >= 18)
m.addConstr(12*system_administrators + 4*network_administrators + 4*pen_testers >= 18)
m.addConstr(14*security_engineers + 12*system_administrators + 4*pen_testers >= 18)
m.addConstr(12*system_administrators + 4*network_administrators + 4*pen_testers >= 18)
m.addConstr(14*security_engineers + 12*system_administrators + 4*network_administrators + 4*pen_testers >= 18)
m.addConstr(10*system_administrators - 7*pen_testers >= 0)
m.addConstr(5*network_administrators - 6*pen_testers >= 0)
m.addConstr(5*network_administrators + 7*pen_testers <= 104)
m.addConstr(1*security_engineers + 7*pen_testers <= 54)
m.addConstr(1*security_engineers + 11*system_administrators + 5*network_administrators <= 49)
m.addConstr(11*system_administrators + 5*network_administrators + 7*pen_testers <= 75)
m.addConstr(9*security_engineers + 7*pen_testers <= 34)
m.addConstr(9*security_engineers + 4*system_administrators + 7*pen_testers <= 36)
m.addConstr(12*system_administrators + 4*pen_testers <= 74)
m.addConstr(12*system_administrators + 4*network_administrators <= 70)


# Resource Constraints
m.addConstr(security_engineers <= 113)
m.addConstr(system_administrators <= 24)
m.addConstr(network_administrators <= 22)
m.addConstr(pen_testers <= 16)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

