
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="system_administrators", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(2*x0 + x1 + 7*x2 + 6*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 + 11*x1 >= 13)
m.addConstr(x0 + 7*x3 >= 15)
m.addConstr(5*x2 + 7*x3 >= 15)
m.addConstr(x0 + 11*x1 + 5*x2 + 7*x3 >= 15)
m.addConstr(x2 + 7*x3 >= 15)
m.addConstr(x1 + x2 >= 20)
m.addConstr(9*x0 + x2 >= 16)
m.addConstr(9*x0 + x2 + 7*x3 >= 22)
m.addConstr(9*x0 + 4*x1 + x2 + 7*x3 >= 22)
m.addConstr(14*x0 + 12*x1 >= 13)
m.addConstr(14*x0 + 4*x2 >= 11)
m.addConstr(12*x1 + 4*x3 >= 11)
m.addConstr(14*x0 + 4*x3 >= 21)
m.addConstr(14*x0 + 12*x1 + 4*x3 >= 18)
m.addConstr(12*x1 + 4*x2 + 4*x3 >= 18)
m.addConstr(14*x0 + 12*x1 + 4*x3 >= 18)
m.addConstr(12*x1 + 4*x2 + 4*x3 >= 18)
m.addConstr(14*x0 + 12*x1 + 4*x2 + 4*x3 >= 18)
m.addConstr(10*x1 - 7*x3 >= 0)
m.addConstr(5*x2 - 6*x3 >= 0)
m.addConstr(5*x2 + 7*x3 <= 104)
m.addConstr(x0 + 7*x3 <= 54)
m.addConstr(x0 + 11*x1 + 5*x2 <= 49)
m.addConstr(11*x1 + 5*x2 + 7*x3 <= 75)
m.addConstr(9*x0 + 7*x3 <= 34)
m.addConstr(9*x0 + 4*x1 + 7*x3 <= 36)
m.addConstr(12*x1 + 4*x3 <= 74)
m.addConstr(12*x1 + 4*x2 <= 70)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Security Engineers: ", x0.varValue)
    print("System Administrators: ", x1.varValue)
    print("Network Administrators: ", x2.varValue)
    print("Pen Testers: ", x3.varValue)
else:
    print("The model is infeasible")
