
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
red_pens = m.addVar(vtype=gp.GRB.INTEGER, name="red_pens")
black_pens = m.addVar(vtype=gp.GRB.INTEGER, name="black_pens")
rubber_bands = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_bands")
printers_3d = m.addVar(vtype=gp.GRB.INTEGER, name="3D_printers")
smoke_detectors = m.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")


# Set objective function
m.setObjective(8 * red_pens + 6 * black_pens + 5 * rubber_bands + 8 * printers_3d + 1 * smoke_detectors, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * printers_3d + 3 * smoke_detectors >= 20)
m.addConstr(3 * red_pens + 3 * smoke_detectors >= 29)
m.addConstr(3 * rubber_bands + 8 * printers_3d >= 54)
m.addConstr(6 * black_pens + 3 * smoke_detectors >= 50)
m.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 32)
m.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 32)
m.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 32)
m.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 30)
m.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 30)
m.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 30)
m.addConstr(6 * black_pens + 8 * printers_3d + 3 * smoke_detectors >= 35)
m.addConstr(3 * red_pens + 8 * printers_3d + 3 * smoke_detectors >= 35)
m.addConstr(6 * black_pens + 3 * rubber_bands + 3 * smoke_detectors >= 35)
m.addConstr(5 * red_pens + 9 * black_pens + 3 * printers_3d >= 21)
m.addConstr(5 * red_pens + 9 * black_pens + 5 * rubber_bands >= 21)
m.addConstr(5 * rubber_bands + 3 * printers_3d + 1 * smoke_detectors >= 21)
m.addConstr(5 * red_pens + 9 * black_pens + 1 * smoke_detectors >= 21)

# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

