
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b12 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
vitamin_b2 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b2")


# Set objective function
m.setObjective(7.67*vitamin_b7**2 + 1.72*vitamin_b7*vitamin_b12 + 8.57*vitamin_b7*vitamin_b2 + 8.81*vitamin_b12**2 + 2.9*vitamin_b12*zinc + 7.6*zinc**2 + 1.36*zinc*vitamin_b2 + 5.69*vitamin_b7 + 5.34*zinc, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*vitamin_b12 + 13*zinc >= 14)
m.addConstr(11*vitamin_b12 + 12*vitamin_b2 >= 10)
m.addConstr(10*vitamin_b7**2 + 13*zinc**2 >= 8)
m.addConstr(13*zinc + 12*vitamin_b2 >= 8)
m.addConstr(10*vitamin_b7 + 11*vitamin_b12 >= 12)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 + 10*zinc >= 67)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 + 11*vitamin_b2 >= 67)
m.addConstr(9*vitamin_b7**2 + 5*vitamin_b12**2 + 10*zinc**2 >= 49)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 + 11*vitamin_b2 >= 49)
m.addConstr(10*vitamin_b7 + 11*vitamin_b12 <= 48)
m.addConstr(10*vitamin_b7**2 + 13*zinc**2 <= 31)
m.addConstr(10*vitamin_b7 + 12*vitamin_b2 <= 60)
m.addConstr(11*vitamin_b12 + 13*zinc <= 42)
m.addConstr(10*vitamin_b7 + 11*vitamin_b12 + 13*zinc + 12*vitamin_b2 <= 42)
m.addConstr(9*vitamin_b7**2 + 11*vitamin_b2**2 <= 194)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 <= 228)
m.addConstr(9*vitamin_b7**2 + 10*zinc**2 <= 195)
m.addConstr(5*vitamin_b12**2 + 10*zinc**2 + 11*vitamin_b2**2 <= 194)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 + 11*vitamin_b2 <= 141)
m.addConstr(9*vitamin_b7 + 5*vitamin_b12 + 10*zinc + 11*vitamin_b2 <= 141)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

