
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(5, name=["medical_platoons", "signal_platoons", "water_purification_units", "mechanized_infantry_companies", "armored_companies"], vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(6*x[0] + 2*x[1] + 9*x[2] + x[3] + x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x[0] + 5*x[1] + 1*x[2] + 2*x[3] + 3*x[4] <= 92, "logistical_capacity")
    m.addConstr(5*x[0] + 5*x[1] >= 6, "c1")
    m.addConstr(5*x[0] + 2*x[3] >= 18, "c2")
    m.addConstr(2*x[3] + 3*x[4] >= 17, "c3")
    m.addConstr(5*x[0] + 5*x[1] + 2*x[3] >= 9, "c4")
    m.addConstr(5*x[1] + 2*x[3] + 3*x[4] >= 9, "c5")
    m.addConstr(5*x[0] + 5*x[1] + 2*x[3] >= 14, "c6")
    m.addConstr(5*x[1] + 2*x[3] + 3*x[4] >= 14, "c7")
    m.addConstr(-10*x[1] + 7*x[4] >= 0, "c8")
    m.addConstr(5*x[1] + 3*x[4] <= 64, "c9")
    m.addConstr(5*x[1] + 2*x[3] <= 46, "c10")
    m.addConstr(x[2] + 5*x[1] + 3*x[4] <= 30, "c11")
    m.addConstr(x[2] + 2*x[3] + 3*x[4] <= 58, "c12")
    m.addConstr(5*x[0] + 2*x[3] + 3*x[4] <= 41, "c13")
    m.addConstr(5*x[0] + x[2] + 2*x[3] <= 45, "c14")
    m.addConstr(5*x[0] + 5*x[1] + x[2] + 2*x[3] + 3*x[4] <= 45, "c15")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
