
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="armored_companies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6 * x1 + 2 * x2 + 9 * x3 + x4 + x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x1 <= 92)
    model.addConstr(5 * x2 <= 92)
    model.addConstr(x3 <= 92)
    model.addConstr(2 * x4 <= 92)
    model.addConstr(3 * x5 <= 92)
    model.addConstr(5 * x1 + 5 * x2 >= 6)
    model.addConstr(5 * x1 + 2 * x4 >= 18)
    model.addConstr(2 * x4 + 3 * x5 >= 17)
    model.addConstr(5 * x1 + 5 * x2 + 2 * x4 >= 9)
    model.addConstr(5 * x2 + 2 * x4 + 3 * x5 >= 9)
    model.addConstr(5 * x1 + 5 * x2 + 2 * x4 >= 14)
    model.addConstr(5 * x2 + 2 * x4 + 3 * x5 >= 14)
    model.addConstr(-10 * x2 + 7 * x5 >= 0)
    model.addConstr(5 * x2 + 3 * x5 <= 64)
    model.addConstr(5 * x2 + 2 * x4 <= 46)
    model.addConstr(5 * x2 + x3 + 3 * x5 <= 30)
    model.addConstr(x3 + 2 * x4 + 3 * x5 <= 58)
    model.addConstr(5 * x1 + 2 * x4 + 3 * x5 <= 41)
    model.addConstr(5 * x1 + x3 + 2 * x4 <= 45)
    model.addConstr(5 * x1 + 5 * x2 + x3 + 2 * x4 + 3 * x5 <= 45)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Medical platoons: ", x1.varValue)
        print("Signal platoons: ", x2.varValue)
        print("Water purification units: ", x3.varValue)
        print("Mechanized infantry companies: ", x4.varValue)
        print("Armored companies: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
