
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
strips_of_bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")


# Set objective function
m.setObjective(6.76 * bananas + 8.33 * chicken_thighs + 5.66 * strips_of_bacon, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11.46 * bananas + 6.36 * chicken_thighs >= 17, "c0")
m.addConstr(6.36 * chicken_thighs + 4.63 * strips_of_bacon >= 30, "c1")
m.addConstr(11.46 * bananas + 6.36 * chicken_thighs + 4.63 * strips_of_bacon >= 23, "c2")
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs >= 52, "c3")
m.addConstr(10.01 * chicken_thighs + 7.3 * strips_of_bacon >= 27, "c4")
m.addConstr(6.51 * bananas + 7.3 * strips_of_bacon >= 51, "c5")
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs + 7.3 * strips_of_bacon >= 51, "c6")
m.addConstr(11.08 * bananas + 10.99 * strips_of_bacon >= 10, "c7")
m.addConstr(11.08 * bananas + 5.82 * chicken_thighs + 10.99 * strips_of_bacon >= 10, "c8")
m.addConstr(8 * bananas - 6 * strips_of_bacon >= 0, "c9")
m.addConstr(-1 * bananas + 3 * chicken_thighs >= 0, "c10")
m.addConstr(11.46 * bananas + 4.63 * strips_of_bacon <= 119, "c11")
m.addConstr(6.36 * chicken_thighs + 4.63 * strips_of_bacon <= 123, "c12")
m.addConstr(6.51 * bananas + 7.3 * strips_of_bacon <= 168, "c13")
m.addConstr(10.01 * chicken_thighs + 7.3 * strips_of_bacon <= 107, "c14")
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs <= 171, "c15")
m.addConstr(11.08 * bananas + 10.99 * strips_of_bacon <= 16, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

