
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="bananas", lb=-gurobi.GRB.INFINITY)
    x1 = model.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="strips_of_bacon", lb=-gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(6.76 * x0 + 8.33 * x1 + 5.66 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11.46 * x0 + 6.36 * x1 + 4.63 * x2 <= 135)
    model.addConstr(6.51 * x0 <= 179)
    model.addConstr(11.08 * x0 <= 31)
    model.addConstr(6.36 * x1 <= 135)
    model.addConstr(10.01 * x1 <= 179)
    model.addConstr(5.82 * x1 <= 31)
    model.addConstr(4.63 * x2 <= 135)
    model.addConstr(7.3 * x2 <= 179)
    model.addConstr(10.99 * x2 <= 31)
    model.addConstr(11.46 * x0 + 6.36 * x1 >= 17)
    model.addConstr(6.36 * x1 + 4.63 * x2 >= 30)
    model.addConstr(11.46 * x0 + 6.36 * x1 + 4.63 * x2 >= 23)
    model.addConstr(6.51 * x0 + 10.01 * x1 >= 52)
    model.addConstr(10.01 * x1 + 7.3 * x2 >= 27)
    model.addConstr(6.51 * x0 + 7.3 * x2 >= 51)
    model.addConstr(6.51 * x0 + 10.01 * x1 + 7.3 * x2 >= 51)
    model.addConstr(11.08 * x0 + 10.99 * x2 >= 10)
    model.addConstr(11.08 * x0 + 5.82 * x1 + 10.99 * x2 >= 10)
    model.addConstr(8 * x0 - 6 * x2 >= 0)
    model.addConstr(-x0 + 3 * x1 >= 0)
    model.addConstr(11.46 * x0 + 4.63 * x2 <= 119)
    model.addConstr(6.36 * x1 + 4.63 * x2 <= 123)
    model.addConstr(6.51 * x0 + 7.3 * x2 <= 168)
    model.addConstr(10.01 * x1 + 7.3 * x2 <= 107)
    model.addConstr(6.51 * x0 + 10.01 * x1 <= 171)
    model.addConstr(11.08 * x0 + 10.99 * x2 <= 16)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {x0.varValue}")
        print(f"Chicken Thighs: {x1.varValue}")
        print(f"Strips of Bacon: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
