
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
color_printers = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")
headsets = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")
red_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
paper_clips = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
lanyards = m.addVar(vtype=gp.GRB.INTEGER, name="lanyards")


# Set objective function
m.setObjective(9.97 * color_printers + 7.52 * headsets + 4.8 * red_highlighters + 3.16 * paper_clips + 6.17 * lanyards, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * headsets + 12 * red_highlighters >= 55)
m.addConstr(12 * red_highlighters + 10 * lanyards >= 24)
m.addConstr(11 * headsets + 26 * paper_clips >= 49)


# ... (rest of the constraints from the JSON "constraints" section)

m.addConstr(15 * color_printers + 11 * headsets + 12 * red_highlighters + 26 * paper_clips + 10 * lanyards <= 319)
m.addConstr(8 * color_printers + 6 * headsets + 17 * red_highlighters + 22 * paper_clips + 24 * lanyards <= 171)
m.addConstr(13 * color_printers + 9 * headsets + 20 * red_highlighters + 20 * paper_clips + 23 * lanyards <= 270)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('color_printers:', color_printers.x)
    print('headsets:', headsets.x)
    print('red_highlighters:', red_highlighters.x)
    print('paper_clips:', paper_clips.x)
    print('lanyards:', lanyards.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

