
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
paul = m.addVar(lb=0, name="Paul")
peggy = m.addVar(lb=0, name="Peggy")
george = m.addVar(lb=0, name="George")
john = m.addVar(lb=0, name="John")
bill = m.addVar(lb=0, name="Bill")


# Set objective function
m.setObjective(4.8 * paul + 2.5 * peggy + 7.69 * george + 6.14 * john + 2.26 * bill, gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'vars': [9.47, 9.74, 1.25, 9.86, 0.4], 'ub': 483},
    'r1': {'vars': [7.96, 10.52, 7.05, 5.72, 3.07], 'ub': 190},
    'r2': {'vars': [7.97, 4.04, 10.09, 0.4, 11.21], 'ub': 240}
}

for resource, data in resource_constraints.items():
    m.addConstr(gp.LinExpr(data['vars'], [paul, peggy, george, john, bill]) <= data['ub'], name=resource)


m.addConstr(9.86 * john + 0.4 * bill >= 53)
m.addConstr(1.25 * george + 0.4 * bill >= 80)
m.addConstr(9.47 * paul + 0.4 * bill >= 76)
m.addConstr(9.74 * peggy + 0.4 * bill >= 72)
m.addConstr(9.74 * peggy + 1.25 * george >= 88)
m.addConstr(9.74 * peggy + 9.86 * john >= 91)
m.addConstr(1.25 * george + 9.86 * john >= 33)
m.addConstr(9.74 * peggy + 9.86 * john + 0.4 * bill >= 77)
m.addConstr(9.47 * paul + 1.25 * george + 9.86 * john >= 77)
# ... (rest of the constraints as in the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

