
import gurobi as gp

# Define variables
model = gp.Model()
x0 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="system_administrators")
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="security_engineers")
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="security_onions")
x3 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
x4 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="automatic_alerts")
x5 = model.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="SOC_operators")

# Objective function
model.setObjective(8.63*x0 + 6.26*x1 + 6.28*x2 + 5.24*x3 + 5.69*x4 + 3.69*x5, gp.GRB.MINIMIZE)

# Add constraints
# Power consumption constraints
model.addConstr(10*x0 + 10*x1 + 6*x2 + 7*x3 + 3*x4 + 4*x5 <= 92)
model.addConstr(10*x0 + 6*x2 + 3*x4 >= 15)
model.addConstr(10*x1 + 6*x2 + 4*x5 >= 9)

# Bandwidth constraints
model.addConstr(11*x0 + x1 + 7*x2 + 7*x3 + x4 + 15*x5 <= 430)

# Network integrity impact constraints
model.addConstr(16*x0 + 6*x1 + 8*x2 + 11*x3 + 17*x4 + 3*x5 <= 114)

# Network latency constraints
model.addConstr(13*x0 + 4*x1 + 14*x2 + 13*x3 + 4*x4 + 13*x5 <= 335)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("System Administrators: ", x0.varValue)
    print("Security Engineers: ", x1.varValue)
    print("Security Onions: ", x2.varValue)
    print("Mbps Bandwidth Allocated to Monitoring: ", x3.varValue)
    print("Automatic Alerts: ", x4.varValue)
    print("SOC Operators: ", x5.varValue)
else:
    print("No optimal solution found")
