
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_instant_ramen")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")


    # Set objective function
    m.setObjective(3*x0 + 3*x1 + 7*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 13*x1 >= 108, "c1")
    m.addConstr(11*x0 + 24*x2 >= 90, "c2")
    m.addConstr(11*x0 + 13*x1 + 24*x2 >= 90, "c3")
    m.addConstr(18*x0 + 5*x1 >= 42, "c4")
    m.addConstr(18*x0 + 8*x2 >= 67, "c5")
    m.addConstr(5*x1 + 8*x2 >= 106, "c6")
    m.addConstr(18*x0 + 5*x1 + 8*x2 >= 63, "c7")
    m.addConstr(-2*x0 + 6*x2 >= 0, "c8")
    m.addConstr(9*x0 - 2*x1 >= 0, "c9")
    m.addConstr(11*x0 + 13*x1 <= 319, "c10")
    m.addConstr(11*x0 + 24*x2 <= 303, "c11")

    # Resource Constraints
    m.addConstr(11*x0 + 13*x1 + 24*x2 <= 448, "r0")
    m.addConstr(18*x0 + 5*x1 + 8*x2 <= 331, "r1")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bowls_of_cereal:', x0.x)
        print('bowls_of_instant_ramen:', x1.x)
        print('tomatoes:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
