
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="bowls_of_cereal", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="bowls_of_instant_ramen", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="tomatoes", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3*x0 + 3*x1 + 7*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x0 + 13*x1 >= 108)
m.addConstr(11*x0 + 24*x2 >= 90)
m.addConstr(11*x0 + 13*x1 + 24*x2 >= 90)
m.addConstr(18*x0 + 5*x1 >= 42)
m.addConstr(18*x0 + 8*x2 >= 67)
m.addConstr(5*x1 + 8*x2 >= 106)
m.addConstr(18*x0 + 5*x1 + 8*x2 >= 63)
m.addConstr(-2*x0 + 6*x2 >= 0)
m.addConstr(9*x0 - 2*x1 >= 0)
m.addConstr(11*x0 + 13*x1 <= 319)
m.addConstr(11*x0 + 24*x2 <= 303)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bowls of cereal: {x0.varValue}")
    print(f"Bowls of instant ramen: {x1.varValue}")
    print(f"Tomatoes: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
