
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(vtype=gp.GRB.INTEGER, name="fat")
vitamin_c = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_c")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_b3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")


# Set objective function
m.setObjective(4*fat + 5*vitamin_c + 5*iron + 2*vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*vitamin_c + 6*iron >= 15)
m.addConstr(7*fat + 6*vitamin_c >= 8)
m.addConstr(6*vitamin_c + 5*vitamin_b3 >= 8)
m.addConstr(7*fat + 5*vitamin_b3 >= 8)
m.addConstr(6*vitamin_c + 6*iron + 5*vitamin_b3 >= 18)
m.addConstr(7*fat + 6*vitamin_c + 6*iron + 5*vitamin_b3 >= 18)
m.addConstr(3*vitamin_c + 8*iron >= 11)
m.addConstr(8*iron + 10*vitamin_b3 >= 19)
m.addConstr(1*fat + 3*vitamin_c >= 15)
m.addConstr(3*vitamin_c + 8*iron + 10*vitamin_b3 >= 25)
m.addConstr(1*fat + 3*vitamin_c + 8*iron + 10*vitamin_b3 >= 25)
m.addConstr(6*vitamin_c + 3*vitamin_b3 >= 23)
m.addConstr(8*fat + 6*vitamin_c >= 19)
m.addConstr(6*vitamin_c + 9*iron >= 23)
m.addConstr(8*fat + 9*iron + 3*vitamin_b3 >= 22)
m.addConstr(8*fat + 6*vitamin_c + 9*iron + 3*vitamin_b3 >= 22)
m.addConstr(6*fat + 3*vitamin_b3 >= 21)
m.addConstr(3*vitamin_c + 3*vitamin_b3 >= 16)
m.addConstr(6*fat + 3*vitamin_c + 6*iron + 3*vitamin_b3 >= 16)
m.addConstr(9*fat + 7*vitamin_c >= 16)
m.addConstr(9*fat + 7*vitamin_c + 2*iron + 7*vitamin_b3 >= 16)
m.addConstr(10*vitamin_c - 7*iron >= 0)
m.addConstr(-9*fat + 7*vitamin_c >= 0)
m.addConstr(6*iron + 5*vitamin_b3 <= 25)
m.addConstr(8*iron + 10*vitamin_b3 <= 88)
m.addConstr(1*fat + 10*vitamin_b3 <= 84)
m.addConstr(9*iron + 3*vitamin_b3 <= 77)
m.addConstr(8*fat + 3*vitamin_b3 <= 46)
m.addConstr(9*fat + 7*vitamin_b3 <= 20)
m.addConstr(2*iron + 7*vitamin_b3 <= 35)
m.addConstr(7*vitamin_c + 2*iron <= 23)
m.addConstr(7*vitamin_c + 7*vitamin_b3 <= 50)
m.addConstr(9*fat + 7*vitamin_c + 2*iron <= 76)
m.addConstr(9*fat + 2*iron + 7*vitamin_b3 <= 50)
m.addConstr(7*vitamin_c + 2*iron + 7*vitamin_b3 <= 60)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Fat: %g' % fat.x)
    print('Vitamin C: %g' % vitamin_c.x)
    print('Iron: %g' % iron.x)
    print('Vitamin B3: %g' % vitamin_b3.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
