
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # grams of fat
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin C
x2 = m.addVar(name="x2")  # milligrams of iron
x3 = m.addVar(name="x3")  # milligrams of vitamin B3

# Define the objective function
m.setObjective(4 * x0 + 5 * x1 + 5 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x1 + 6 * x2 >= 15)
m.addConstr(7 * x0 + 6 * x1 >= 8)
m.addConstr(6 * x1 + 5 * x3 >= 8)
m.addConstr(7 * x0 + 5 * x3 >= 8)
m.addConstr(6 * x1 + 6 * x2 + 5 * x3 >= 18)
m.addConstr(7 * x0 + 6 * x1 + 6 * x2 + 5 * x3 >= 18)
m.addConstr(3 * x1 + 8 * x2 >= 11)
m.addConstr(8 * x2 + 10 * x3 >= 19)
m.addConstr(x0 + 3 * x1 >= 15)
m.addConstr(3 * x1 + 8 * x2 + 10 * x3 >= 25)
m.addConstr(x0 + 3 * x1 + 8 * x2 + 10 * x3 >= 25)
m.addConstr(6 * x1 + 3 * x3 >= 23)
m.addConstr(8 * x0 + 6 * x1 >= 19)
m.addConstr(6 * x1 + 9 * x2 >= 23)
m.addConstr(8 * x0 + 9 * x2 + 3 * x3 >= 22)
m.addConstr(8 * x0 + 6 * x1 + 9 * x2 + 3 * x3 >= 22)
m.addConstr(6 * x0 + 3 * x3 >= 21)
m.addConstr(3 * x1 + 3 * x3 >= 16)
m.addConstr(6 * x0 + 3 * x1 + 6 * x2 + 3 * x3 >= 16)
m.addConstr(9 * x0 + 7 * x1 >= 16)
m.addConstr(9 * x0 + 7 * x1 + 2 * x2 + 7 * x3 >= 16)
m.addConstr(10 * x1 - 7 * x2 >= 0)
m.addConstr(-9 * x0 + 7 * x1 >= 0)
m.addConstr(6 * x2 + 5 * x3 <= 25)
m.addConstr(8 * x2 + 10 * x3 <= 88)
m.addConstr(x0 + 10 * x3 <= 84)
m.addConstr(9 * x2 + 3 * x3 <= 77)
m.addConstr(8 * x0 + 3 * x3 <= 46)
m.addConstr(9 * x0 + 7 * x3 <= 20)
m.addConstr(2 * x2 + 7 * x3 <= 35)
m.addConstr(7 * x1 + 2 * x2 <= 23)
m.addConstr(7 * x1 + 7 * x3 <= 50)
m.addConstr(9 * x0 + 7 * x1 + 2 * x2 <= 76)
m.addConstr(9 * x0 + 2 * x2 + 7 * x3 <= 50)
m.addConstr(7 * x1 + 2 * x2 + 7 * x3 <= 60)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No solution found")
