
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x5")


# Set objective function
obj = 4*x0**2 + 5*x0*x1 + 8*x0*x2 + 3*x0*x3 + 8*x0*x4 + 9*x1**2 + 4*x1*x2 + 4*x1*x3 + 4*x1*x4 + 2*x1*x5 + 5*x2**2 + 2*x2*x3 + 7*x2*x4 + 9*x2*x5 + 2*x3**2 + 7*x3*x4 + 2*x3*x5 + 2*x4**2 + 1*x4*x5 + 2*x0 + 3*x1 + 3*x3 + 7*x4 + 2*x5

m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 + 4*x1 + 14*x2 + 5*x3 + 15*x4 + 4*x5 <= 123)
m.addConstr(4*x1**2 + 14*x2**2 >= 15)
m.addConstr(3*x0**2 + 14*x2**2 >= 19)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

