
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin C
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # grams of fiber
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B3
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")  # milligrams of vitamin B7
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x5")  # milligrams of vitamin D
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x6")  # grams of fat

    # Objective function
    model.setObjective(4*x1**2 + 5*x1*x2 + 8*x1*x3 + 3*x1*x4 + 8*x1*x5 + 9*x2**2 + 4*x2*x3 + 4*x2*x4 + 4*x2*x5 + 2*x2*x6 + 5*x3**2 + 2*x3*x4 + 7*x3*x5 + 9*x3*x6 + 2*x4**2 + 7*x4*x5 + 2*x4*x6 + 2*x5**2 + x5*x6 + 2*x1 + 3*x2 + 3*x4 + 7*x5 + 2*x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x1 == 3, name="c1")
    model.addConstr(4*x2 == 4, name="c2")
    model.addConstr(14*x3 == 14, name="c3")
    model.addConstr(5*x4 == 5, name="c4")
    model.addConstr(15*x5 == 15, name="c5")
    model.addConstr(4*x6 == 4, name="c6")
    model.addConstr(4*x2**2 + 14*x3**2 >= 15, name="c7")
    model.addConstr(x1**2 + x3**2 >= 19, name="c8")
    model.addConstr(x1 + x5 >= 9, name="c9")
    model.addConstr(x3**2 + x5**2 >= 15, name="c10")
    model.addConstr(x4**2 + x6**2 >= 18, name="c11")
    model.addConstr(x1 + x2 >= 9, name="c12")
    model.addConstr(x2**2 + x6**2 >= 7, name="c13")
    model.addConstr(x2 + x4 + x5 >= 14, name="c14")
    model.addConstr(x2 + x3 + x4 >= 14, name="c15")
    model.addConstr(x1 + x2 + x3 >= 14, name="c16")
    model.addConstr(x3 + x4 + x5 >= 14, name="c17")
    model.addConstr(x3**2 + x4**2 + x6**2 >= 14, name="c18")
    model.addConstr(x2**2 + x3**2 + x5**2 >= 14, name="c19")
    model.addConstr(x2 + x5 + x6 >= 14, name="c20")
    model.addConstr(x1 + x2 + x5 >= 14, name="c21")
    model.addConstr(x2**2 + x4**2 + x6**2 >= 14, name="c22")
    model.addConstr(x4 + x5 + x6 >= 14, name="c23")
    model.addConstr(x1 + x3 + x4 >= 14, name="c24")
    model.addConstr(x1 + x3 + x5 >= 14, name="c25")
    model.addConstr(x1 + x5 + x6 >= 14, name="c26")
    model.addConstr(x1 + x2 + x4 >= 14, name="c27")
    model.addConstr(x2**2 + x4**2 + x5**2 >= 19, name="c28")
    model.addConstr(x2**2 + x3**2 + x4**2 >= 19, name="c29")
    model.addConstr(x1**2 + x2**2 + x3**2 >= 19, name="c30")
    model.addConstr(x3 + x4 + x5 >= 19, name="c31")
    model.addConstr(x3**2 + x4**2 + x6**2 >= 19, name="c32")
    model.addConstr(x2**2 + x3**2 + x5**2 >= 19, name="c33")
    model.addConstr(x2 + x5 + x6 <= 86, name="c34")
    model.addConstr(x1 + x2 + x6 <= 81, name="c35")
    model.addConstr(x1 + x3 + x6 <= 120, name="c36")
    model.addConstr(6*x2**2 - 8*x5**2 >= 0, name="c37")
    model.addConstr(x1 + x3 <= 90, name="c38")
    model.addConstr(x5**2 + x6**2 <= 83, name="c39")
    model.addConstr(x4**2 + x5**2 <= 80, name="c40")
    model.addConstr(x1 + x4 <= 41, name="c41")
    model.addConstr(x1**2 + x5**2 <= 104, name="c42")
    model.addConstr(x2 + x6 <= 55, name="c43")
    model.addConstr(x3 + x5 <= 70, name="c44")
    model.addConstr(x2**2 + x4**2 <= 88, name="c45")
    model.addConstr(x3 + x4 <= 100, name="c46")
    model.addConstr(x2 + x3 <= 112, name="c47")
    model.addConstr(x2**2 + x4**2 + x6**2 <= 75, name="c48")
    model.addConstr(x1 + x3 + x5 <= 91, name="c49")
    model.addConstr(x2 + x4 + x5 <= 31, name="c50")
    model.addConstr(x2 + x3 + x4 <= 31, name="c51")
    model.addConstr(x2 + x5 + x6 <= 86, name="c52")
    model.addConstr(x1 + x2 + x6 <= 81, name="c53")
    model.addConstr(x1 + x3 + x6 <= 120, name="c54")
    model.addConstr(x1**2 + x2**2 + x4**2 <= 34, name="c55")
    model.addConstr(x3**2 + x5**2 + x6**2 <= 100, name="c56")
    model.addConstr(x1 + x4 + x5 <= 25, name="c57")
    model.addConstr(x1 + x2 + x5 <= 48, name="c58")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
