
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="x0")  # milligrams of vitamin B6
    x1 = m.addVar(name="x1")  # milligrams of calcium
    x2 = m.addVar(name="x2")  # milligrams of iron


    # Set objective function
    m.setObjective(2*x0**2 + 9*x0*x1 + 7*x0*x2 + 8*x1**2 + 9*x1*x2 + 5*x0 + 9*x1 + 3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.33*x0 + 0.89*x2 >= 24)
    m.addConstr(5.47*x1 + 0.89*x2 >= 37)
    m.addConstr(4.33*x0**2 + 5.47*x1**2 + 0.89*x2**2 >= 34)
    m.addConstr(3.53*x1 + 1.44*x2 >= 25)
    m.addConstr(5.28*x0 + 1.44*x2 >= 36)
    m.addConstr(2.24*x1 + 1.4*x2 >= 20)
    m.addConstr(0.38*x0 + 1.4*x2 >= 31)
    m.addConstr(0.38*x0**2 + 2.24*x1**2 >= 14)
    m.addConstr(0.38*x0 + 2.24*x1 + 1.4*x2 >= 40)
    m.addConstr(-10*x0 + 4*x2 >= 0)
    m.addConstr(5.47*x1 + 0.89*x2 <= 94)
    m.addConstr(4.33*x0 + 5.47*x1 <= 120)
    m.addConstr(4.33*x0 + 5.47*x1 + 0.89*x2 <= 120)
    m.addConstr(5.28*x0**2 + 1.44*x2**2 <= 97)
    m.addConstr(5.28*x0 + 3.53*x1 <= 63)
    m.addConstr(5.28*x0 + 3.53*x1 + 1.44*x2 <= 63)
    m.addConstr(0.38*x0 + 1.4*x2 <= 102)
    m.addConstr(0.38*x0 + 2.24*x1 + 1.4*x2 <= 102)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
