
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(2*x1**2 + 9*x1*x2 + 7*x1*x3 + 8*x2**2 + 9*x2*x3 + 5*x1 + 9*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4.33*x1 <= 120)
model.addConstr(5.28*x1 <= 129)
model.addConstr(0.38*x1 <= 126)
model.addConstr(5.47*x2 <= 120)
model.addConstr(3.53*x2 <= 129)
model.addConstr(2.24*x2 <= 126)
model.addConstr(0.89*x3 <= 120)
model.addConstr(1.44*x3 <= 129)
model.addConstr(1.4*x3 <= 126)
model.addConstr(4.33*x1 + 0.89*x3 >= 24)
model.addConstr(5.47*x2 + 0.89*x3 >= 37)
model.addConstr((4.33*x1)**2 + (5.47*x2)**2 + (0.89*x3)**2 >= 34)
model.addConstr(3.53*x2 + 1.44*x3 >= 25)
model.addConstr(5.28*x1 + 1.44*x3 >= 36)
model.addConstr(2.24*x2 + 1.4*x3 >= 20)
model.addConstr(0.38*x1 + 1.4*x3 >= 31)
model.addConstr((0.38*x1)**2 + (2.24*x2)**2 >= 14)
model.addConstr(0.38*x1 + 2.24*x2 + 1.4*x3 >= 40)
model.addConstr(-10*x1 + 4*x3 >= 0)
model.addConstr(5.47*x2 + 0.89*x3 <= 94)
model.addConstr(4.33*x1 + 5.47*x2 <= 120)
model.addConstr(4.33*x1 + 5.47*x2 + 0.89*x3 <= 120)
model.addConstr((5.28*x1)**2 + (1.44*x3)**2 <= 97)
model.addConstr(5.28*x1 + 3.53*x2 <= 63)
model.addConstr(5.28*x1 + 3.53*x2 + 1.44*x3 <= 63)
model.addConstr(0.38*x1 + 1.4*x3 <= 102)
model.addConstr(0.38*x1 + 2.24*x2 + 1.4*x3 <= 102)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
