
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="apple_pies")
sashimi = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sashimi")
fruit_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")

# Set objective function
m.setObjective(6.65 * apple_pies + 8.92 * sashimi + 8.8 * fruit_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * apple_pies + 12 * fruit_salads >= 23, "iron_constraint1")
m.addConstr(10 * sashimi + 1 * fruit_salads >= 26, "cost_constraint1")
m.addConstr(12 * apple_pies + 10 * sashimi <= 83, "iron_constraint2")
m.addConstr(12 * apple_pies + 12 * fruit_salads <= 47, "iron_constraint3")
m.addConstr(12 * apple_pies + 10 * sashimi + 12 * fruit_salads <= 47, "iron_constraint4")
m.addConstr(9 * apple_pies + 3 * sashimi <= 164, "carbohydrates_constraint1")
m.addConstr(9 * apple_pies + 3 * sashimi + 14 * fruit_salads <= 143, "carbohydrates_constraint2")
m.addConstr(11 * apple_pies + 2 * sashimi <= 215, "tastiness_constraint1")
m.addConstr(2 * sashimi + 10 * fruit_salads <= 88, "tastiness_constraint2")
m.addConstr(11 * apple_pies + 2 * sashimi + 10 * fruit_salads <= 100, "tastiness_constraint3")
m.addConstr(2 * apple_pies + 1 * fruit_salads <= 70, "cost_constraint2")
m.addConstr(2 * apple_pies + 10 * sashimi + 1 * fruit_salads <= 44, "cost_constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    print('Apple Pies:', apple_pies.x)
    print('Sashimi:', sashimi.x)
    print('Fruit Salads:', fruit_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

