
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="apple_pies", lb=0)
    x1 = model.addVar(name="sashimi", lb=0)
    x2 = model.addVar(name="fruit_salads", lb=0)

    # Define the objective function
    model.setObjective(6.65 * x0 + 8.92 * x1 + 8.8 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x0 + 10 * x1 + 12 * x2 <= 116)  # milligrams of iron
    model.addConstr(9 * x0 + 3 * x1 + 14 * x2 <= 247)  # grams of carbohydrates
    model.addConstr(11 * x0 + 2 * x1 + 10 * x2 <= 264)  # tastiness rating
    model.addConstr(2 * x0 + 10 * x1 + x2 <= 112)  # dollar cost
    model.addConstr(12 * x0 + 12 * x2 >= 23)  # milligrams of iron from apple pies and fruit salads
    model.addConstr(10 * x1 + x2 >= 26)  # dollar cost from sashimi and fruit salads
    model.addConstr(12 * x0 + 10 * x1 <= 83)  # milligrams of iron from apple pies and sashimi
    model.addConstr(12 * x0 + 12 * x2 <= 47)  # milligrams of iron from apple pies and fruit salads
    model.addConstr(12 * x0 + 10 * x1 + 12 * x2 <= 47)  # milligrams of iron from all
    model.addConstr(9 * x0 + 3 * x1 <= 164)  # grams of carbohydrates from apple pies and sashimi
    model.addConstr(9 * x0 + 3 * x1 + 14 * x2 <= 143)  # grams of carbohydrates from all
    model.addConstr(11 * x0 + 2 * x1 <= 215)  # tastiness rating from apple pies and sashimi
    model.addConstr(2 * x1 + 10 * x2 <= 88)  # tastiness rating from sashimi and fruit salads
    model.addConstr(11 * x0 + 2 * x1 + 10 * x2 <= 100)  # tastiness rating from all
    model.addConstr(2 * x0 + x2 <= 70)  # dollar cost from apple pies and fruit salads
    model.addConstr(2 * x0 + 10 * x1 + x2 <= 44)  # dollar cost from all

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Apple Pies: ", x0.varValue)
        print("Sashimi: ", x1.varValue)
        print("Fruit Salads: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
