
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["bananas", "cherry pies", "bowls of instant ramen", "apple pies", "chicken thighs"])


    # Set objective function
    m.setObjective(4*x[0] + 6*x[1] + 2*x[2] + 6*x[3] + 9*x[4], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x[0] + 3*x[1] >= 5, "c1")
    m.addConstr(5*x[3] + 2*x[4] >= 8, "c2")
    m.addConstr(3*x[1] + 2*x[2] >= 3, "c3")
    m.addConstr(2*x[0] + 3*x[1] + 2*x[4] >= 6, "c4")
    m.addConstr(2*x[0] + 3*x[1] + 2*x[2] + 5*x[3] + 2*x[4] >= 6, "c5")
    m.addConstr(3*x[1] + 2*x[2] <= 32, "c6")
    m.addConstr(2*x[2] + 5*x[3] <= 35, "c7")
    m.addConstr(2*x[0] + 2*x[2] + 2*x[4] <= 33, "c8")
    m.addConstr(2*x[0] + 3*x[1] + 2*x[2] + 5*x[3] + 2*x[4] <= 43, "c9")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print(f'Error code {e.errno}: {e}')

except AttributeError:
    print('Encountered an attribute error')
