
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cherry_pies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4*x1 + 6*x2 + 2*x3 + 6*x4 + 9*x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 3*x2 >= 5)
    model.addConstr(5*x4 + 2*x5 >= 8)
    model.addConstr(3*x2 + 2*x3 >= 3)
    model.addConstr(2*x1 + 3*x2 + 2*x5 >= 6)
    model.addConstr(2*x1 + 3*x2 + 2*x3 + 5*x4 + 2*x5 >= 6)
    model.addConstr(3*x2 + 2*x3 <= 32)
    model.addConstr(2*x3 + 5*x4 <= 35)
    model.addConstr(2*x1 + 2*x3 + 2*x5 <= 33)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {x1.varValue}")
        print(f"Cherry pies: {x2.varValue}")
        print(f"Bowls of instant ramen: {x3.varValue}")
        print(f"Apple pies: {x4.varValue}")
        print(f"Chicken thighs: {x5.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
