
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(5*x0 + 1*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 2*x2 >= 8)
    model.addConstr(7*x0 + 3*x1 + 2*x2 >= 8)
    model.addConstr(3*x0 + 7*x2 >= 34)
    model.addConstr(3*x0 + 6*x1 + 7*x2 >= 33)
    model.addConstr(5*x0 + 8*x2 >= 25)
    model.addConstr(5*x0 + 5*x1 >= 25)
    model.addConstr(5*x1 + 8*x2 >= 21)
    model.addConstr(5*x0 + 5*x1 + 8*x2 >= 21)
    model.addConstr(4*x0 + 5*x2 >= 8)
    model.addConstr(4*x0 + 3*x1 >= 22)
    model.addConstr(3*x1 + 5*x2 >= 11)
    model.addConstr(4*x0 + 3*x1 + 5*x2 >= 11)
    model.addConstr(-1*x0 + 5*x2 >= 0)
    model.addConstr(3*x1 + 2*x2 <= 46)
    model.addConstr(7*x0 + 2*x2 <= 41)
    model.addConstr(6*x1 + 7*x2 <= 88)
    model.addConstr(3*x0 + 6*x1 <= 51)
    model.addConstr(3*x0 + 7*x2 <= 89)
    model.addConstr(4*x0 + 3*x1 <= 36)
    model.addConstr(4*x0 + 3*x1 + 5*x2 <= 28)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
