
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", lb=0)
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)

# Define the objective function
m.setObjective(5 * x0 + x1 + 5 * x2, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(7 * x0 <= 7, name="Dale_likelihood_to_quit")
m.addConstr(3 * x0 <= 3, name="Dale_organization_score")
m.addConstr(5 * x0 <= 5, name="Dale_work_quality_rating")
m.addConstr(4 * x0 <= 4, name="Dale_computer_competence_rating")

m.addConstr(3 * x1 <= 3, name="Peggy_likelihood_to_quit")
m.addConstr(6 * x1 <= 6, name="Peggy_organization_score")
m.addConstr(5 * x1 <= 5, name="Peggy_work_quality_rating")
m.addConstr(3 * x1 <= 3, name="Peggy_computer_competence_rating")

m.addConstr(2 * x2 <= 2, name="Laura_likelihood_to_quit")
m.addConstr(7 * x2 <= 7, name="Laura_organization_score")
m.addConstr(8 * x2 <= 8, name="Laura_work_quality_rating")
m.addConstr(5 * x2 <= 5, name="Laura_computer_competence_rating")

m.addConstr(3 * x1 + 2 * x2 >= 8, name="Peggy_Laura_likelihood_to_quit")
m.addConstr(7 * x0 + 3 * x1 + 2 * x2 >= 8, name="Dale_Peggy_Laura_likelihood_to_quit")
m.addConstr(3 * x0 + 7 * x2 >= 34, name="Dale_Laura_organization_score")
m.addConstr(3 * x0 + 6 * x1 + 7 * x2 >= 33, name="Dale_Peggy_Laura_organization_score")
m.addConstr(5 * x0 + 8 * x2 >= 25, name="Dale_Laura_work_quality_rating")
m.addConstr(5 * x0 + 5 * x1 >= 25, name="Dale_Peggy_work_quality_rating")
m.addConstr(5 * x1 + 8 * x2 >= 21, name="Peggy_Laura_work_quality_rating")
m.addConstr(5 * x0 + 5 * x1 + 8 * x2 >= 21, name="Dale_Peggy_Laura_work_quality_rating")
m.addConstr(4 * x0 + 5 * x2 >= 8, name="Dale_Laura_computer_competence_rating")
m.addConstr(4 * x0 + 3 * x1 >= 22, name="Dale_Peggy_computer_competence_rating")
m.addConstr(3 * x1 + 5 * x2 >= 11, name="Peggy_Laura_computer_competence_rating")
m.addConstr(4 * x0 + 3 * x1 + 5 * x2 >= 11, name="Dale_Peggy_Laura_computer_competence_rating")

m.addConstr(-x0 + 5 * x2 >= 0, name="Dale_Laura_relationship")
m.addConstr(3 * x1 + 2 * x2 <= 46, name="Peggy_Laura_likelihood_to_quit_max")
m.addConstr(7 * x0 + 2 * x2 <= 41, name="Dale_Laura_likelihood_to_quit_max")
m.addConstr(6 * x1 + 7 * x2 <= 88, name="Peggy_Laura_organization_score_max")
m.addConstr(3 * x0 + 6 * x1 <= 51, name="Dale_Peggy_organization_score_max")
m.addConstr(3 * x0 + 7 * x2 <= 89, name="Dale_Laura_organization_score_max")
m.addConstr(4 * x0 + 3 * x1 <= 36, name="Dale_Peggy_computer_competence_rating_max")
m.addConstr(4 * x0 + 3 * x1 + 5 * x2 <= 28, name="Dale_Peggy_Laura_computer_competence_rating_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Dale: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
else:
    print("The model is infeasible")
