
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    potatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potatoes")
    fruit_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    hot_dogs = m.addVar(vtype=gp.GRB.INTEGER, name="hot_dogs")


    # Set objective function
    m.setObjective(3.74 * potatoes + 5.88 * fruit_salads + 8.09 * hot_dogs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19 * potatoes + 9 * fruit_salads >= 29)
    m.addConstr(9 * fruit_salads + 3 * hot_dogs >= 30)
    m.addConstr(19 * potatoes + 9 * fruit_salads + 3 * hot_dogs >= 46)
    m.addConstr(18 * potatoes + 10 * hot_dogs >= 30)
    m.addConstr(18 * potatoes + 16 * fruit_salads + 10 * hot_dogs >= 30)
    m.addConstr(6 * potatoes + 3 * fruit_salads >= 29)
    m.addConstr(3 * fruit_salads + 17 * hot_dogs >= 41)
    m.addConstr(6 * potatoes + 17 * hot_dogs >= 17)
    m.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs >= 17)
    m.addConstr(26 * fruit_salads + 22 * hot_dogs >= 37)
    m.addConstr(1 * potatoes + 22 * hot_dogs >= 23)
    m.addConstr(1 * potatoes + 26 * fruit_salads + 22 * hot_dogs >= 23)
    m.addConstr(1 * fruit_salads - 5 * hot_dogs >= 0)
    m.addConstr(9 * fruit_salads + 3 * hot_dogs <= 95)
    m.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs <= 57)

    # Resource Constraints
    m.addConstr(19 * potatoes <= 155)
    m.addConstr(18 * potatoes <= 130)
    m.addConstr(6 * potatoes <= 133)
    m.addConstr(1 * potatoes <= 141)
    m.addConstr(9 * fruit_salads <= 155)
    m.addConstr(16 * fruit_salads <= 130)
    m.addConstr(3 * fruit_salads <= 133)
    m.addConstr(26 * fruit_salads <= 141)
    m.addConstr(3 * hot_dogs <= 155)
    m.addConstr(10 * hot_dogs <= 130)
    m.addConstr(17 * hot_dogs <= 133)
    m.addConstr(22 * hot_dogs <= 141)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
