
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    potatoes = model.addVar(name="potatoes", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)
    hot_dogs = model.addVar(name="hot_dogs", lb=0, integrality=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.74 * potatoes + 5.88 * fruit_salads + 8.09 * hot_dogs, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * potatoes + 9 * fruit_salads >= 29)
    model.addConstr(9 * fruit_salads + 3 * hot_dogs >= 30)
    model.addConstr(19 * potatoes + 9 * fruit_salads + 3 * hot_dogs >= 46)
    model.addConstr(18 * potatoes + 10 * hot_dogs >= 30)
    model.addConstr(18 * potatoes + 16 * fruit_salads + 10 * hot_dogs >= 30)
    model.addConstr(6 * potatoes + 3 * fruit_salads >= 29)
    model.addConstr(3 * fruit_salads + 17 * hot_dogs >= 41)
    model.addConstr(6 * potatoes + 17 * hot_dogs >= 17)
    model.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs >= 17)
    model.addConstr(26 * fruit_salads + 22 * hot_dogs >= 37)
    model.addConstr(potatoes + 22 * hot_dogs >= 23)
    model.addConstr(potatoes + 26 * fruit_salads + 22 * hot_dogs >= 23)
    model.addConstr(fruit_salads - 5 * hot_dogs >= 0)
    model.addConstr(9 * fruit_salads + 3 * hot_dogs <= 95)
    model.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs <= 57)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Fruit Salads: {fruit_salads.varValue}")
        print(f"Hot Dogs: {hot_dogs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
