
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")


    # Set objective function
    m.setObjective(4.5 * x0 + 5.52 * x1 + 1.67 * x2 + 4.26 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 5 * x3 >= 25)
    m.addConstr(5 * x2 + 5 * x3 >= 21)
    m.addConstr(13 * x1 + 5 * x2 >= 18)
    m.addConstr(10 * x0 + 13 * x1 >= 28)
    m.addConstr(10 * x0 + 5 * x2 >= 18)
    m.addConstr(10 * x0 + 13 * x1 + 5 * x3 >= 14)
    m.addConstr(10 * x0 + 5 * x2 + 5 * x3 >= 14)
    m.addConstr(10 * x0 + 13 * x1 + 5 * x3 >= 16)
    m.addConstr(10 * x0 + 5 * x2 + 5 * x3 >= 16)
    m.addConstr(1 * x0 + 12 * x3 <= 71)
    m.addConstr(5 * x1 + 12 * x3 <= 136)
    m.addConstr(6 * x2 + 12 * x3 <= 181)
    m.addConstr(5 * x1 + 6 * x2 + 12 * x3 <= 48)
    m.addConstr(1 * x0 + 6 * x2 + 12 * x3 <= 187)
    m.addConstr(1 * x0 + 5 * x1 + 6 * x2 + 12 * x3 <= 187)
    m.addConstr(10 * x0 + 5 * x3 <= 82)
    m.addConstr(5 * x2 + 5 * x3 <= 105)
    m.addConstr(13 * x1 + 5 * x2 <= 57)
    m.addConstr(13 * x1 + 5 * x3 <= 74)
    m.addConstr(10 * x0 + 13 * x1 + 5 * x3 <= 36)
    m.addConstr(10 * x0 + 13 * x1 + 5 * x2 <= 96)
    m.addConstr(10 * x0 + 13 * x1 + 5 * x2 + 5 * x3 <= 96)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
