
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # red highlighters
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # staplers
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # manila envelopes
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # monochrome printers

    # Define the objective function
    model.setObjective(4.5 * x0 + 5.52 * x1 + 1.67 * x2 + 4.26 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x0 + 5 * x3 >= 25)
    model.addConstr(5 * x2 + 5 * x3 >= 21)
    model.addConstr(13 * x1 + 5 * x2 >= 18)
    model.addConstr(10 * x0 + 13 * x1 >= 28)
    model.addConstr(10 * x0 + 5 * x2 >= 18)
    model.addConstr(10 * x0 + 13 * x1 + 5 * x3 >= 14)
    model.addConstr(10 * x0 + 5 * x2 + 5 * x3 >= 14)
    model.addConstr(10 * x0 + 13 * x1 + 5 * x3 >= 16)
    model.addConstr(10 * x0 + 5 * x2 + 5 * x3 >= 16)
    model.addConstr(x0 + 12 * x3 <= 71)
    model.addConstr(5 * x1 + 12 * x3 <= 136)
    model.addConstr(6 * x2 + 12 * x3 <= 181)
    model.addConstr(5 * x1 + 6 * x2 + 12 * x3 <= 48)
    model.addConstr(x0 + 6 * x2 + 12 * x3 <= 187)
    model.addConstr(x0 + 5 * x1 + 6 * x2 + 12 * x3 <= 187)
    model.addConstr(10 * x0 + 5 * x3 <= 82)
    model.addConstr(5 * x2 + 5 * x3 <= 105)
    model.addConstr(13 * x1 + 5 * x2 <= 57)
    model.addConstr(13 * x1 + 5 * x3 <= 74)
    model.addConstr(10 * x0 + 13 * x1 + 5 * x3 <= 36)
    model.addConstr(10 * x0 + 13 * x1 + 5 * x2 <= 96)
    model.addConstr(10 * x0 + 13 * x1 + 5 * x2 + 5 * x3 <= 96)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
