
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, lb=0, name=["John", "Jean", "Bobby", "Mary", "Bill", "Laura"])

# Set integer constraints
x[0].vtype = gp.GRB.INTEGER
x[1].vtype = gp.GRB.INTEGER
x[4].vtype = gp.GRB.INTEGER
x[5].vtype = gp.GRB.INTEGER


# Set objective function
m.setObjective(7 * x[0] + 5 * x[1] + 4 * x[2] + 2 * x[3] + 4 * x[4] + 3 * x[5], gp.GRB.MAXIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': [16, 9, 27, 17, 17, 21],
    'r1': [9, 1, 18, 23, 22, 1],
    'r2': [7, 23, 25, 13, 15, 20],
    'r3': [1, 17, 15, 26, 5, 8],
    'r4': [25, 17, 7, 26, 29, 26]
}

# Add constraints from the problem description
constraints = [
    (resource_coeffs['r0'][1] * x[1] + resource_coeffs['r0'][2] * x[2] >= 35),
    # ... (all other constraints from the JSON "constraints" field)
]

for constraint in constraints:
    m.addConstr(constraint)

# Resource upper bounds
resource_bounds = {
    'r0': 359,
    'r1': 390,
    'r2': 910,
    'r3': 828,
    'r4': 204
}

for r, bound in resource_bounds.items():
    m.addConstr(gp.quicksum(resource_coeffs[r][i] * x[i] for i in range(6)) <= bound)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

