
import gurobi as gp

m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="hours_worked_by_John", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Jean", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Bobby")
x3 = m.addVar(name="hours_worked_by_Mary")
x4 = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(7 * x0 + 5 * x1 + 4 * x2 + 2 * x3 + 4 * x4 + 3 * x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(16 * x0 <= 359)
m.addConstr(9 * x0 <= 390)
m.addConstr(7 * x0 <= 910)
m.addConstr(x0 <= 828)
m.addConstr(25 * x0 <= 204)

m.addConstr(9 * x1 <= 359)
m.addConstr(x1 <= 390)
m.addConstr(23 * x1 <= 910)
m.addConstr(17 * x1 <= 828)
m.addConstr(17 * x1 <= 204)

m.addConstr(27 * x2 <= 359)
m.addConstr(18 * x2 <= 390)
m.addConstr(25 * x2 <= 910)
m.addConstr(15 * x2 <= 828)
m.addConstr(7 * x2 <= 204)

m.addConstr(17 * x3 <= 359)
m.addConstr(23 * x3 <= 390)
m.addConstr(13 * x3 <= 910)
m.addConstr(26 * x3 <= 828)
m.addConstr(26 * x3 <= 204)

m.addConstr(17 * x4 <= 359)
m.addConstr(22 * x4 <= 390)
m.addConstr(15 * x4 <= 910)
m.addConstr(5 * x4 <= 828)
m.addConstr(29 * x4 <= 204)

m.addConstr(21 * x5 <= 359)
m.addConstr(x5 <= 390)
m.addConstr(20 * x5 <= 910)
m.addConstr(8 * x5 <= 828)
m.addConstr(26 * x5 <= 204)

m.addConstr(9 * x1 + 27 * x2 >= 35)
m.addConstr(16 * x0 + 17 * x3 >= 44)
m.addConstr(9 * x1 + 21 * x5 >= 32)
m.addConstr(15 * x2 + 26 * x3 >= 46)
m.addConstr(16 * x0 + 9 * x1 + 21 * x5 >= 50)
m.addConstr(9 * x1 + 27 * x2 + 17 * x3 >= 50)
m.addConstr(16 * x0 + 17 * x3 + 21 * x5 >= 50)
m.addConstr(27 * x2 + 17 * x3 + 21 * x5 >= 50)
m.addConstr(16 * x0 + 9 * x1 + 21 * x5 >= 55)
m.addConstr(9 * x1 + 27 * x2 + 17 * x3 >= 55)
m.addConstr(16 * x0 + 17 * x3 + 21 * x5 >= 55)
m.addConstr(27 * x2 + 17 * x3 + 21 * x5 >= 55)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", x0.varValue)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
    print("Hours worked by Bill: ", x4.varValue)
    print("Hours worked by Laura: ", x5.varValue)
else:
    print("No optimal solution found")
