
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
    hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")


    # Set objective function
    m.setObjective(5.97 * eggs + 9.26 * hot_dogs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * eggs + 6 * hot_dogs >= 12, "fiber_min")
    m.addConstr(1 * eggs + 9 * hot_dogs >= 4, "sourness_min")
    m.addConstr(-3 * eggs + 2 * hot_dogs >= 0, "eggs_hot_dogs_relation")
    m.addConstr(7 * eggs + 6 * hot_dogs <= 26, "fiber_max")
    m.addConstr(1 * eggs + 9 * hot_dogs <= 21, "sourness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Eggs: {eggs.x}")
        print(f"Hot dogs: {hot_dogs.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
