
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")

# Set the objective function
m.setObjective(5.97*x1 + 9.26*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 6*x2 <= 53, "fiber_upper_bound")
m.addConstr(x1 + 9*x2 <= 25, "sourness_index_upper_bound")
m.addConstr(7*x1 + 6*x2 >= 12, "minimum_fiber_requirement")
m.addConstr(x1 + 9*x2 >= 4, "minimum_sourness_index_requirement")
m.addConstr(-3*x1 + 2*x2 >= 0, "linear_constraint")
m.addConstr(7*x1 + 6*x2 <= 26, "fiber_upper_bound_26")
m.addConstr(x1 + 9*x2 <= 21, "sourness_index_upper_bound_21")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eggs: {x1.x}, Hot Dogs: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
