
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    eggs = model.addVar(name="eggs", lb=0)  # Quantity of eggs
    hot_dogs = model.addVar(name="hot_dogs", lb=0)  # Quantity of hot dogs

    # Objective function: Maximize 5.97*eggs + 9.26*hot_dogs
    model.setObjective(5.97 * eggs + 9.26 * hot_dogs, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * eggs + 6 * hot_dogs >= 12, name="fiber_constraint")  # At least 12 grams of fiber
    model.addConstr(eggs + 9 * hot_dogs >= 4, name="sourness_index_constraint")  # Sourness index
    model.addConstr(-3 * eggs + 2 * hot_dogs >= 0, name="linear_combination_constraint")  # Linear combination
    model.addConstr(7 * eggs + 6 * hot_dogs <= 53, name="total_fiber_constraint")  # Total fiber
    model.addConstr(eggs + 9 * hot_dogs <= 21, name="total_sourness_constraint")  # Total sourness

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Eggs: {eggs.varValue}")
        print(f"Hot Dogs: {hot_dogs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
