
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
sashimi = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sashimi")
kale_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kale_salads")
corn_cobs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
steaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
kiwis = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(8 * sashimi + 5 * kale_salads + 8 * corn_cobs + 9 * steaks + 5 * kiwis, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * sashimi + 26 * kale_salads + 2 * corn_cobs + 5 * steaks + 1 * kiwis <= 176, "calcium_upper_bound")
m.addConstr(26 * kale_salads + 5 * steaks + 1 * kiwis >= 32, "calcium_lower_bound")
m.addConstr(2 * corn_cobs + 5 * steaks <= 81, "calcium_corn_steaks")
m.addConstr(17 * sashimi + 1 * kiwis <= 48, "calcium_sashimi_kiwis")
m.addConstr(17 * sashimi + 2 * corn_cobs + 1 * kiwis <= 110, "calcium_sashimi_corn_kiwis")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('sashimi:', sashimi.x)
    print('kale_salads:', kale_salads.x)
    print('corn_cobs:', corn_cobs.x)
    print('steaks:', steaks.x)
    print('kiwis:', kiwis.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

