
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='sashimi', lb=0)
    x2 = model.addVar(name='kale_salads', lb=0)
    x3 = model.addVar(name='corn_cobs', lb=0)
    x4 = model.addVar(name='steaks', lb=0)
    x5 = model.addVar(name='kiwis', lb=0)

    # Define the objective function
    model.setObjective(8*x1 + 5*x2 + 8*x3 + 9*x4 + 5*x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(26*x2 + 5*x4 + x5 >= 32)
    model.addConstr(2*x3 + 5*x4 <= 81)
    model.addConstr(17*x1 + x5 <= 48)
    model.addConstr(17*x1 + 2*x3 + x5 <= 110)
    model.addConstr(17*x1 + 26*x2 + 2*x3 + 5*x4 + x5 <= 110)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('sashimi: ', x1.varValue)
        print('kale salads: ', x2.varValue)
        print('corn cobs: ', x3.varValue)
        print('steaks: ', x4.varValue)
        print('kiwis: ', x5.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
