
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    paul_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="paul_hours")
    peggy_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


    # Set objective function
    model.setObjective(7.41 * paul_hours + 3.98 * peggy_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * paul_hours + 6 * peggy_hours >= 34, "dollar_cost_min")
    model.addConstr(6 * paul_hours + 5 * peggy_hours >= 31, "productivity_min")
    model.addConstr(-9 * paul_hours + 3 * peggy_hours >= 0, "paul_peggy_relation")
    model.addConstr(7 * paul_hours + 6 * peggy_hours <= 75, "dollar_cost_max")
    model.addConstr(6 * paul_hours + 5 * peggy_hours <= 38, "productivity_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Paul's hours: {paul_hours.x}")
        print(f"Peggy's hours: {peggy_hours.x}")
        print(f"Objective value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
