
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, name="hours_worked_by_Peggy")

# Set the objective function
m.setObjective(7.41*x1 + 3.98*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 6*x2 >= 34, "total_dollar_cost_at_least_34")
m.addConstr(6*x1 + 5*x2 >= 31, "total_productivity_rating_at_least_31")
m.addConstr(-9*x1 + 3*x2 >= 0, "constraint_on_hours_worked")
m.addConstr(7*x1 + 6*x2 <= 75, "total_dollar_cost_at_most_75")
m.addConstr(6*x1 + 5*x2 <= 38, "total_productivity_rating_at_most_38")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Peggy: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
